// Данные о стримерах
const streamers = {
  ma1ne: {
    name: "ma1neeeee",
    tagline: "Twitch Streamer",
    avatar: "images/ma1ne.png", // Локальная картинка
    description: "Это стример ma1neeeee, который транслирует игры на Twitch.",
    links: [
      { name: "Twitch", url: "https://www.twitch.tv/ma1neeeee" }
    ]
  },
  andrew_omron: {
    name: "Andrew_Omron",
    tagline: "Gaming Content Creator",
    avatar: "images/andrew_omron.png", // Локальная картинка
    description: "Andrew_Omron — создатель контента для геймеров.",
    links: [
      { name: "Twitch", url: "https://www.twitch.tv/andrew_omron" },
      { name: "YouTube", url: "https://www.youtube.com/@AndrewOmron" },
      { name: "Telegram", url: "https://t.me/omrontv" }
    ]
  },
  cte6hu: {
    name: "CTE6HU_ww",
    tagline: "Tech Enthusiast",
    avatar: "images/cte6hu.png", // Локальная картинка
    description: "CTE6HU_ww — энтузиаст технологий и стример.",
    links: [
      { name: "Twitch", url: "https://www.twitch.tv/cte6hu_ww" },
      { name: "TikTok", url: "https://www.tiktok.com/@cte6hu" },
      { name: "YouTube", url: "https://www.youtube.com/@CTE6HU" },
      { name: "Telegram", url: "https://t.me/cte6hu_ww" }
    ]
  },
  odysseyg21: {
    name: "odysseyg21",
    tagline: "Геймер & Музыкант",
    avatar: "images/odyssey.png", // Локальная картинка
    description: "OdysseyG21 — геймер и музыкант",
    links: [
      { name: "Twitch", url: "https://www.twitch.tv/odysseyg21" },
      { name: "Discord", url: "https://discord.com/invite/d42FNRuBSU" },
      { name: "YouTube", url: "https://www.youtube.com/channel/UCic-eYeKF5kt4LM3PGJUhiA" },
      { name: "Telegram", url: "https://t.me/odysseyg1" }
    ]
  },
  twist666: {
    name: "twist666twist",
    tagline: "Казуальный стример",
    avatar: "images/twist666.png", // Локальная картинка
    description: "Twist666twist — неформальный стример.",
    links: [
      { name: "Twitch", url: "https://www.twitch.tv/twist666twist" },
      { name: "Telegram", url: "https://t.me/twist666channel" }
    ]
  }
};

// Получаем элементы
const servers = document.querySelectorAll('.server');
const streamerInfoElement = document.querySelector('.streamer-info');

// Функция для создания карточки стримера
function createStreamerCard(streamer) {
  const card = document.createElement('div');
  card.className = 'streamer-card';

  // Аватарка
  const avatarContainer = document.createElement('div');
  avatarContainer.className = 'avatar-container';

  const avatar = document.createElement('img');
  avatar.src = streamer.avatar;
  avatar.alt = streamer.name + ' Avatar';
  avatar.className = 'avatar';

  avatarContainer.appendChild(avatar);

  // Имя и теглайн
  const nameElement = document.createElement('h2');
  nameElement.className = 'streamer-name';
  nameElement.textContent = `Стример: ${streamer.name}`;

  const taglineElement = document.createElement('p');
  taglineElement.className = 'streamer-tagline';
  taglineElement.textContent = streamer.tagline;

  // Добавляем элементы в карточку
  card.appendChild(avatarContainer);
  card.appendChild(nameElement);
  card.appendChild(taglineElement);

  return card;
}

// Функция для обновления информации о стримере
function updateStreamerInfo(streamerKey) {
  const streamer = streamers[streamerKey];
  if (streamer) {
    // Очищаем правую панель
    streamerInfoElement.innerHTML = '';

    // Создаем карточку стримера
    const streamerCard = createStreamerCard(streamer);
    streamerInfoElement.appendChild(streamerCard);

    // Создаем раздел "Информация"
    const infoSection = document.createElement('div');
    infoSection.className = 'info-section info';

    const descriptionHeader = document.createElement('h3');
    descriptionHeader.textContent = 'Информация:';

    const descriptionElement = document.createElement('p');
    descriptionElement.className = 'streamer-description';
    descriptionElement.textContent = streamer.description;

    infoSection.appendChild(descriptionHeader);
    infoSection.appendChild(descriptionElement);

    // Создаем раздел "Ссылки"
    const linksSection = document.createElement('div');
    linksSection.className = 'info-section links';

    const linksHeader = document.createElement('h4');
    linksHeader.textContent = 'Ссылки:';

    const linkList = document.createElement('ul');
    linkList.className = 'link-list';

    streamer.links.forEach(link => {
      const listItem = document.createElement('li');
      listItem.className = 'link-item';

      const linkElement = document.createElement('a');
      linkElement.href = link.url;
      linkElement.target = '_blank';
      linkElement.textContent = `${link.name}: ${link.url}`;

      listItem.appendChild(linkElement);
      linkList.appendChild(listItem);
    });

    linksSection.appendChild(linksHeader);
    linksSection.appendChild(linkList);

    // Добавляем разделы в правую панель
    streamerInfoElement.appendChild(infoSection);
    streamerInfoElement.appendChild(linksSection);
  }
}

// Добавляем обработчики событий для серверов
servers.forEach(server => {
  server.addEventListener('click', () => {
    const streamerKey = server.getAttribute('data-streamer');
    updateStreamerInfo(streamerKey);

    // Удаляем активный класс у всех серверов
    servers.forEach(s => s.classList.remove('active-server'));
    server.classList.add('active-server');
  });
});

// Активный сервер по умолчанию
servers[0].classList.add('active-server');
updateStreamerInfo('ma1ne');
