/*
 * leds-lp3944.h - platform data structure for lp3944 led controller
 *
 * Copyright (C) 2009 Antonio Ospite <ospite@studenti.unina.it>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __LINUX_LEDS_LM3533_H
#define __LINUX_LEDS_LM3533_H
////20130722 tracy add for notification led++
#define LM3533_LED0 0
#define LM3533_LED1 1
#define LM3533_LED2 2
#define LM3533_LEDS_MAX 3
////20130722 tracy add for notification led--
#define LM3533_LED_STATUS_MASK	0x03

#define LM3533_CURRENT_SINK_OUTPUT_CONFIGURATION1 0x10
#define LM3533_CURRENT_SINK_OUTPUT_CONFIGURATION2 0x11
#define LM3533_STARTUP_SHUTDOWN_RAMP_RATES 0x12
#define LM3533_RUN_TIME_RAMP_RATES 0x13
#define LM3533_CONTROL_BANK_A_PWM_CONFIGURATION 0x14
#define LM3533_CONTROL_BANK_B_PWM_CONFIGURATION 0x15
#define LM3533_CONTROL_BANK_C_PWM_CONFIGURATION 0x16
#define LM3533_CONTROL_BANK_D_PWM_CONFIGURATION 0x17
#define LM3533_CONTROL_BANK_E_PWM_CONFIGURATION 0x18
#define LM3533_CONTROL_BANK_F_PWM_CONFIGURATION 0x19
#define LM3533_CONTROL_BANK_A_B_BRIGHTNESS_CONFIGURATION 0x1A
#define LM3533_CONTROL_BANK_C_BRIGHTNESS_CONFIGURATION 0x1B
#define LM3533_CONTROL_BANK_D_BRIGHTNESS_CONFIGURATION 0x1C
#define LM3533_CONTROL_BANK_E_BRIGHTNESS_CONFIGURATION 0x1D
#define LM3533_CONTROL_BANK_F_BRIGHTNESS_CONFIGURATION 0x1E
#define LM3533_CONTROL_BANK_A_FULL_SCALE_CURRENT 0x1F
#define LM3533_CONTROL_BANK_B_FULL_SCALE_CURRENT 0x20
#define LM3533_CONTROL_BANK_C_FULL_SCALE_CURRENT 0x21
#define LM3533_CONTROL_BANK_D_FULL_SCALE_CURRENT 0x22
#define LM3533_CONTROL_BANK_E_FULL_SCALE_CURRENT 0x23
#define LM3533_CONTROL_BANK_F_FULL_SCALE_CURRENT 0x24
#define LM3533_CURRENT_SINK_FEEDBACK_ENABLE 0x25
#define LM3533_CHARGE_PUMP_CONTROL 0x26
#define LM3533_CONTROL_ENABLE 0x27
#define LM3533_PATTERN_GENERATOR_ENABLE_ALS_SCALING_CONTROL 0x28
#define LM3533_ALS_PATTERN_SCALE_ZONES_5_4 0x29
#define LM3533_ALS_PATTERN_SCALE_ZONES_3_2 0x2A
#define LM3533_ALS_PATTERN_SCALE_ZONES_1 0x2B
#define LM3533_OVP_FREQUENCY_PWM_POLARITY 0x2C
#define LM3533_R_ALS_SELRCT 0x30
#define LM3533_ALS_CONFIGURATION 0x31
#define LM3533_ALGORITHM_SELECT 0x32
#define LM3533_ALS_DOWN_DELAY_CONTROL 0x33
#define LM3533_READ_BACK_ALS_ZONE 0x34
#define LM3533_READ_BACK_DOWN_DELAY_ALS_ZONE 0x35
#define LM3533_READ_BACK_UP_ONLY_ALS_ZONE 0x36
#define LM3533_READ_BACK_ADC 0x37
#define LM3533_READ_BACK_AVERAGE_ADC 0x38
#define LM3533_BRIGHTNESS_REGISTER_A 0x40
#define LM3533_BRIGHTNESS_REGISTER_B 0x41
#define LM3533_BRIGHTNESS_REGISTER_C 0x42
#define LM3533_BRIGHTNESS_REGISTER_D 0x43
#define LM3533_BRIGHTNESS_REGISTER_E 0x44
#define LM3533_BRIGHTNESS_REGISTER_F 0x45
#define LM3533_ALS_ZONE_BOUNDARY_0_HIGH 0x50
#define LM3533_ALS_ZONE_BOUNDARY_0_LOW 0x51
#define LM3533_ALS_ZONE_BOUNDARY_1_HIGH 0x52
#define LM3533_ALS_ZONE_BOUNDARY_1_LOW 0x53
#define LM3533_ALS_ZONE_BOUNDARY_2_HIGH 0x54
#define LM3533_ALS_ZONE_BOUNDARY_2_LOW 0x55
#define LM3533_ALS_ZONE_BOUNDARY_3_HIGH 0x56
#define LM3533_ALS_ZONE_BOUNDARY_3_LOW 0x57
#define LM3533_ALS_M1_ZONE_TARGET_0 0x60
#define LM3533_ALS_M1_ZONE_TARGET_1 0x61
#define LM3533_ALS_M1_ZONE_TARGET_2 0x62
#define LM3533_ALS_M1_ZONE_TARGET_3 0x63
#define LM3533_ALS_M1_ZONE_TARGET_4 0x64
#define LM3533_ALS_M2_ZONE_TARGET_0 0x65
#define LM3533_ALS_M2_ZONE_TARGET_1 0x66
#define LM3533_ALS_M2_ZONE_TARGET_2 0x67
#define LM3533_ALS_M2_ZONE_TARGET_3 0x68
#define LM3533_ALS_M2_ZONE_TARGET_4 0x69
#define LM3533_ALS_M3_ZONE_TARGET_0 0x6A
#define LM3533_ALS_M3_ZONE_TARGET_1 0x6B
#define LM3533_ALS_M3_ZONE_TARGET_2 0x6C
#define LM3533_ALS_M3_ZONE_TARGET_3 0x6D
#define LM3533_ALS_M3_ZONE_TARGET_4 0x6E
#define LM3533_PATTERN_GENERATOR_1_DELAY 0x70
#define LM3533_PATTERN_GENERATOR_1_LOW_TIME 0x71
#define LM3533_PATTERN_GENERATOR_1_HIGH_TIME 0x72
#define LM3533_PATTERN_GENERATOR_1_LOW_LEVEL_BRIGHTNESS 0x73
#define LM3533_PATTERN_GENERATOR_1_RISE_TIME 0x74
#define LM3533_PATTERN_GENERATOR_1_FALL_TIME 0x75
#define LM3533_PATTERN_GENERATOR_2_DELAY 0x80
#define LM3533_PATTERN_GENERATOR_2_LOW_TIME 0x81
#define LM3533_PATTERN_GENERATOR_2_HIGH_TIME 0x82
#define LM3533_PATTERN_GENERATOR_2_LOW_LEVEL_BRIGHTNESS 0x83
#define LM3533_PATTERN_GENERATOR_2_RISE_TIME 0x84
#define LM3533_PATTERN_GENERATOR_2_FALL_TIME 0x85
#define LM3533_PATTERN_GENERATOR_3_DELAY 0x90
#define LM3533_PATTERN_GENERATOR_3_LOW_TIME 0x91
#define LM3533_PATTERN_GENERATOR_3_HIGH_TIME 0x92
#define LM3533_PATTERN_GENERATOR_3_LOW_LEVEL_BRIGHTNESS 0x93
#define LM3533_PATTERN_GENERATOR_3_RISE_TIME 0x94
#define LM3533_PATTERN_GENERATOR_3_FALL_TIME 0x95
#define LM3533_PATTERN_GENERATOR_4_DELAY 0xA0
#define LM3533_PATTERN_GENERATOR_4_LOW_TIME 0xA1
#define LM3533_PATTERN_GENERATOR_4_HIGH_TIME 0xA2
#define LM3533_PATTERN_GENERATOR_4_LOW_LEVEL_BRIGHTNESS 0xA3
#define LM3533_PATTERN_GENERATOR_4_RISE_TIME 0xA4
#define LM3533_PATTERN_GENERATOR_4_FALL_TIME 0xA5
#define LM3533_OPEN_FAULT_READ_BACK 0xB0
#define LM3533_SHORT_FAULT_READ_BACK 0xB1
#define LM3533_FAULT_ENABLE 0xB2


//20130717 tracy modify unused led code++
struct lm3533_led {
	const char    *name;
};
//20130717 tracy modify unused led code--
enum lm3533_rgb_brightness {
	SNS_NO		= 0,				
	SNS_B		=  1,			
	SNS_G		=  10,			
	SNS_GB		=  11,			
	SNS_R		=  100,				
	SNS_RB		=  101,			
	SNS_RG		=  110,			
	SNS_RGB		=  111,					
};

struct lm3533_platform_data {
	struct lm3533_led leds[LM3533_LEDS_MAX];
	int hwint_gpio;
	int hwint_gpio_flag;
	u8 leds_size;
};

extern void lm3533_backlight_control(unsigned long brightness);

#endif /* __LINUX_LEDS_LM3533_H */
