/*
 * Definitions for GME60X/GMC303 compass chip.
 */
#ifndef GME60X_COMPASS_H
#define GME60X_COMPASS_H

#include <linux/ioctl.h>

/* Device specific constant values */
#define GME60X_REG_WIA1				0x00
#define GME60X_REG_WIA2				0x01
#define GME60X_REG_INFO1			0x02
#define GME60X_REG_INFO2			0x03
#define GME60X_REG_ST1				0x10
#define GME60X_REG_HXL				0x11
#define GME60X_REG_HXH				0x12
#define GME60X_REG_HYL				0x13
#define GME60X_REG_HYH				0x14
#define GME60X_REG_HZL				0x15
#define GME60X_REG_HZH				0x16
#define GME60X_REG_TMPS				0x17
#define GME60X_REG_ST2				0x18
#define GME60X_REG_CNTL1			0x30
#define GME60X_REG_CNTL2			0x31
#define GME60X_REG_CNTL3			0x32

/*! \name GME60X fuse-rom address
\anchor GME60X_FUSE
Defines a read-only address of the fuse ROM of the GME60X.*/
#define GME60X_FUSE_ASAX			0x60
#define GME60X_FUSE_ASAY			0x61
#define GME60X_FUSE_ASAZ			0x62

/*! \name GME60X operation mode
 \anchor GME60X
 Defines an operation mode of the GME60X.*/
#define GME60X_MODE_SNG_MEASURE	0x01
#define GME60X_MODE_SELF_TEST	0x10
#define GME60X_MODE_FUSE_ACCESS	0x1F
#define GME60X_MODE_POWERDOWN	0x00
#define GME60X_RESET_DATA		0x01

#define GME60X_REGS_SIZE		13
#define GME60X_WIA1_VALUE		0x48
#define GME60X_WIA2_VALUE		0x05

/* To avoid device dependency, convert to general name */
#define GME_I2C_NAME			"gme60x"
#define GME_MISCDEV_NAME		"gme60x_dev"
#define GME_SYSCLS_NAME			"compass"
#define GME_SYSDEV_NAME			"gme60x"
#define GME_REG_MODE			GME60X_REG_CNTL2
#define GME_REG_RESET			GME60X_REG_CNTL3
#define GME_REG_STATUS			GME60X_REG_ST1
#define GME_MEASURE_TIME_US		10000
#define GME_DRDY_IS_HIGH(x)		((x) & 0x01)
#define GME_SENSOR_INFO_SIZE	2
#define GME_SENSOR_CONF_SIZE	3
#define GME_SENSOR_DATA_SIZE	9

#define GME_YPR_DATA_SIZE		25
#define GME_RWBUF_SIZE			16
#define GME_REGS_SIZE			GME60X_REGS_SIZE
#define GME_REGS_1ST_ADDR		GME60X_REG_WIA1
#define GME_FUSE_1ST_ADDR		GME60X_FUSE_ASAX

#define GME_MODE_SNG_MEASURE	GME60X_MODE_SNG_MEASURE
#define GME_MODE_SELF_TEST		GME60X_MODE_SELF_TEST
#define GME_MODE_FUSE_ACCESS	GME60X_MODE_FUSE_ACCESS
#define GME_MODE_POWERDOWN		GME60X_MODE_POWERDOWN
#define GME_RESET_DATA			GME60X_RESET_DATA

#define ACC_DATA_FLAG		0
#define MAG_DATA_FLAG		1
#define FUSION_DATA_FLAG	2
#define GME_NUM_SENSORS		3

#define ACC_DATA_READY		(1<<(ACC_DATA_FLAG))
#define MAG_DATA_READY		(1<<(MAG_DATA_FLAG))
#define FUSION_DATA_READY	(1<<(FUSION_DATA_FLAG))

#define GMEIO				0xA1

/* IOCTLs for Msensor misc. device library */
#define ECS_IOCTL_READ				_IOWR(GMEIO, 0x01, char)
#define ECS_IOCTL_WRITE				_IOW(GMEIO, 0x02, char)
#define ECS_IOCTL_RESET				_IO(GMEIO, 0x03)
#define ECS_IOCTL_SET_MODE			_IOW(GMEIO, 0x10, char)
#define ECS_IOCTL_SET_YPR			_IOW(GMEIO, 0x11, int[GME_YPR_DATA_SIZE])
#define ECS_IOCTL_GET_INFO			_IOR(GMEIO, 0x20, unsigned char[GME_SENSOR_INFO_SIZE])
#define ECS_IOCTL_GET_CONF			_IOR(GMEIO, 0x21, unsigned char[GME_SENSOR_CONF_SIZE])
#define ECS_IOCTL_GET_DATA			_IOR(GMEIO, 0x22, unsigned char[GME_SENSOR_DATA_SIZE])
#define ECS_IOCTL_GET_OPEN_STATUS	_IOR(GMEIO, 0x23, int)
#define ECS_IOCTL_GET_CLOSE_STATUS	_IOR(GMEIO, 0x24, int)
#define ECS_IOCTL_GET_DELAY			_IOR(GMEIO, 0x25, long long int)
#define ECS_IOCTL_GET_LAYOUT		_IOR(GMEIO, 0x26, char)
#define ECS_IOCTL_GET_ACCEL			_IOR(GMEIO, 0x30, short[3])

struct gme60x_platform_data {
	char layout;
	int gpio_DRDY;
	int gpio_RSTN;
};
#define AKM_MEASURE_TIME_US 999

/*** Limit of factory shipment test *******************************************/
#define TLIMIT_TN_REVISION_GME60x				""
#define TLIMIT_NO_RST_WIA1_GME60x				"1-3"
#define TLIMIT_TN_RST_WIA1_GME60x				"RST_WIA1"
#define TLIMIT_LO_RST_WIA1_GME60x				0x48
#define TLIMIT_HI_RST_WIA1_GME60x				0x48
#define TLIMIT_NO_RST_WIA2_GME60x				"1-4"
#define TLIMIT_TN_RST_WIA2_GME60x				"RST_WIA2"
#define TLIMIT_LO_RST_WIA2_GME60x				0x05
#define TLIMIT_HI_RST_WIA2_GME60x				0x05

#define TLIMIT_NO_ASAX_GME60x					"1-7"
#define TLIMIT_TN_ASAX_GME60x					"ASAX"
#define TLIMIT_LO_ASAX_GME60x					1
#define TLIMIT_HI_ASAX_GME60x					254
#define TLIMIT_NO_ASAY_GME60x					"1-8"
#define TLIMIT_TN_ASAY_GME60x					"ASAY"
#define TLIMIT_LO_ASAY_GME60x					1
#define TLIMIT_HI_ASAY_GME60x					254
#define TLIMIT_NO_ASAZ_GME60x					"1-9"
#define TLIMIT_TN_ASAZ_GME60x					"ASAZ"
#define TLIMIT_LO_ASAZ_GME60x					1
#define TLIMIT_HI_ASAZ_GME60x					254

#define TLIMIT_NO_SNG_ST1_GME60x				"2-3"
#define TLIMIT_TN_SNG_ST1_GME60x				"SNG_ST1"
#define TLIMIT_LO_SNG_ST1_GME60x				1
#define TLIMIT_HI_SNG_ST1_GME60x				1

#define TLIMIT_NO_SNG_HX_GME60x				"2-4"
#define TLIMIT_TN_SNG_HX_GME60x				"SNG_HX"
#define TLIMIT_LO_SNG_HX_GME60x				-8189
#define TLIMIT_HI_SNG_HX_GME60x				8189

#define TLIMIT_NO_SNG_HY_GME60x				"2-6"
#define TLIMIT_TN_SNG_HY_GME60x				"SNG_HY"
#define TLIMIT_LO_SNG_HY_GME60x				-8189
#define TLIMIT_HI_SNG_HY_GME60x				8189

#define TLIMIT_NO_SNG_HZ_GME60x				"2-8"
#define TLIMIT_TN_SNG_HZ_GME60x				"SNG_HZ"
#define TLIMIT_LO_SNG_HZ_GME60x				-8189
#define TLIMIT_HI_SNG_HZ_GME60x				8189

#define TLIMIT_NO_SNG_ST2_GME60x				"2-10"
#define TLIMIT_TN_SNG_ST2_GME60x				"SNG_ST2"
#define TLIMIT_LO_SNG_ST2_GME60x				0
#define TLIMIT_HI_SNG_ST2_GME60x				0

#define TLIMIT_NO_SLF_ST1_GME60x				"2-13"
#define TLIMIT_TN_SLF_ST1_GME60x				"SLF_ST1"
#define TLIMIT_LO_SLF_ST1_GME60x				1
#define TLIMIT_HI_SLF_ST1_GME60x				1

#define TLIMIT_NO_SLF_RVHX_GME60x				"2-14"
#define TLIMIT_TN_SLF_RVHX_GME60x				"SLF_REVSHX"
#define TLIMIT_LO_SLF_RVHX_GME60x				-40
#define TLIMIT_HI_SLF_RVHX_GME60x				40

#define TLIMIT_NO_SLF_RVHY_GME60x				"2-16"
#define TLIMIT_TN_SLF_RVHY_GME60x				"SLF_REVSHY"
#define TLIMIT_LO_SLF_RVHY_GME60x				-40
#define TLIMIT_HI_SLF_RVHY_GME60x				40

#define TLIMIT_NO_SLF_RVHZ_GME60x				"2-18"
#define TLIMIT_TN_SLF_RVHZ_GME60x				"SLF_REVSHZ"
#define TLIMIT_LO_SLF_RVHZ_GME60x				-320
#define TLIMIT_HI_SLF_RVHZ_GME60x				-80

#define TLIMIT_NO_SLF_ST2_GME60x				"2-20"
#define TLIMIT_TN_SLF_ST2_GME60x				"SLF_ST2"
#define TLIMIT_LO_SLF_ST2_GME60x				0
#define TLIMIT_HI_SLF_ST2_GME60x				0

/*** Limit of factory shipment test *******************************************/

#define TLIMIT_TN_REVISION				""
#define TLIMIT_NO_RST_WIA				"1-3"
#define TLIMIT_TN_RST_WIA				"RST_WIA"
#define TLIMIT_LO_RST_WIA				0x48
#define TLIMIT_HI_RST_WIA				0x48
#define TLIMIT_NO_RST_INFO				"1-4"
#define TLIMIT_TN_RST_INFO				"RST_INFO"
#define TLIMIT_LO_RST_INFO				0
#define TLIMIT_HI_RST_INFO				255
#define TLIMIT_NO_RST_ST1				"1-5"
#define TLIMIT_TN_RST_ST1				"RST_ST1"
#define TLIMIT_LO_RST_ST1				0
#define TLIMIT_HI_RST_ST1				0
#define TLIMIT_NO_RST_HXL				"1-6"
#define TLIMIT_TN_RST_HXL				"RST_HXL"
#define TLIMIT_LO_RST_HXL				0
#define TLIMIT_HI_RST_HXL				0
#define TLIMIT_NO_RST_HXH				"1-7"
#define TLIMIT_TN_RST_HXH				"RST_HXH"
#define TLIMIT_LO_RST_HXH				0
#define TLIMIT_HI_RST_HXH				0
#define TLIMIT_NO_RST_HYL				"1-8"
#define TLIMIT_TN_RST_HYL				"RST_HYL"
#define TLIMIT_LO_RST_HYL				0
#define TLIMIT_HI_RST_HYL				0
#define TLIMIT_NO_RST_HYH				"1-9"
#define TLIMIT_TN_RST_HYH				"RST_HYH"
#define TLIMIT_LO_RST_HYH				0
#define TLIMIT_HI_RST_HYH				0
#define TLIMIT_NO_RST_HZL				"1-10"
#define TLIMIT_TN_RST_HZL				"RST_HZL"
#define TLIMIT_LO_RST_HZL				0
#define TLIMIT_HI_RST_HZL				0
#define TLIMIT_NO_RST_HZH				"1-11"
#define TLIMIT_TN_RST_HZH				"RST_HZH"
#define TLIMIT_LO_RST_HZH				0
#define TLIMIT_HI_RST_HZH				0
#define TLIMIT_NO_RST_ST2				"1-12"
#define TLIMIT_TN_RST_ST2				"RST_ST2"
#define TLIMIT_LO_RST_ST2				0
#define TLIMIT_HI_RST_ST2				0
#define TLIMIT_NO_RST_CNTL				"1-13"
#define TLIMIT_TN_RST_CNTL				"RST_CNTL"
#define TLIMIT_LO_RST_CNTL				0
#define TLIMIT_HI_RST_CNTL				0
#define TLIMIT_NO_RST_ASTC				"1-14"
#define TLIMIT_TN_RST_ASTC				"RST_ASTC"
#define TLIMIT_LO_RST_ASTC				0
#define TLIMIT_HI_RST_ASTC				0
#define TLIMIT_NO_RST_I2CDIS			"1-15"
#define TLIMIT_TN_RST_I2CDIS			"RST_I2CDIS"
#define TLIMIT_LO_RST_I2CDIS_USEI2C		0
#define TLIMIT_HI_RST_I2CDIS_USEI2C		0
#define TLIMIT_LO_RST_I2CDIS_USESPI		1
#define TLIMIT_HI_RST_I2CDIS_USESPI		1
#define TLIMIT_NO_ASAX					"1-17"
#define TLIMIT_TN_ASAX					"ASAX"
#define TLIMIT_LO_ASAX					1
#define TLIMIT_HI_ASAX					254
#define TLIMIT_NO_ASAY					"1-18"
#define TLIMIT_TN_ASAY					"ASAY"
#define TLIMIT_LO_ASAY					1
#define TLIMIT_HI_ASAY					254
#define TLIMIT_NO_ASAZ					"1-19"
#define TLIMIT_TN_ASAZ					"ASAZ"
#define TLIMIT_LO_ASAZ					1
#define TLIMIT_HI_ASAZ					254
#define TLIMIT_NO_WR_CNTL				"1-20"
#define TLIMIT_TN_WR_CNTL				"WR_CNTL"
#define TLIMIT_LO_WR_CNTL				0x0F
#define TLIMIT_HI_WR_CNTL				0x0F

#define TLIMIT_NO_SNG_ST1				"2-3"
#define TLIMIT_TN_SNG_ST1				"SNG_ST1"
#define TLIMIT_LO_SNG_ST1				1
#define TLIMIT_HI_SNG_ST1				1

#define TLIMIT_NO_SNG_HX				"2-4"
#define TLIMIT_TN_SNG_HX				"SNG_HX"
#define TLIMIT_LO_SNG_HX				-32759
#define TLIMIT_HI_SNG_HX				32759

#define TLIMIT_NO_SNG_HY				"2-6"
#define TLIMIT_TN_SNG_HY				"SNG_HY"
#define TLIMIT_LO_SNG_HY				-32759
#define TLIMIT_HI_SNG_HY				32759

#define TLIMIT_NO_SNG_HZ				"2-8"
#define TLIMIT_TN_SNG_HZ				"SNG_HZ"
#define TLIMIT_LO_SNG_HZ				-32759
#define TLIMIT_HI_SNG_HZ				32759

#define TLIMIT_NO_SNG_ST2				"2-10"
#define TLIMIT_TN_SNG_ST2				"SNG_ST2"
#define TLIMIT_LO_SNG_ST2				0
#define TLIMIT_HI_SNG_ST2				0

#define TLIMIT_NO_SLF_ST1				"2-14"
#define TLIMIT_TN_SLF_ST1				"SLF_ST1"
#define TLIMIT_LO_SLF_ST1				1
#define TLIMIT_HI_SLF_ST1				1

#define TLIMIT_NO_SLF_RVHX				"2-15"
#define TLIMIT_TN_SLF_RVHX				"SLF_REVSHX"
#define TLIMIT_LO_SLF_RVHX				-200
#define TLIMIT_HI_SLF_RVHX				200

#define TLIMIT_NO_SLF_RVHY				"2-17"
#define TLIMIT_TN_SLF_RVHY				"SLF_REVSHY"
#define TLIMIT_LO_SLF_RVHY				-200
#define TLIMIT_HI_SLF_RVHY				200

#define TLIMIT_NO_SLF_RVHZ				"2-19"
#define TLIMIT_TN_SLF_RVHZ				"SLF_REVSHZ"
#define TLIMIT_LO_SLF_RVHZ				-3200
#define TLIMIT_HI_SLF_RVHZ				-800

#define TLIMIT_NO_SLF_ST2				"2-21"
#define TLIMIT_TN_SLF_ST2				"SLF_ST2"
#define TLIMIT_LO_SLF_ST2				0
#define TLIMIT_HI_SLF_ST2				0


#endif

