/* Copyright (c) 2012-2014, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/gpio.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <mach/board.h>
#include <mach/gpio.h>
#include <mach/gpiomux.h>
#include <mach/socinfo.h>

#define WLAN_CLK	27
#define WLAN_SET	26
#define WLAN_DATA0	25
#define WLAN_DATA1	24
#define WLAN_DATA2	23

/* << Arima_990211, 20130630, Merge M8610AAAAANLYD1011 */
#if 0
static struct gpiomux_setting gpio_spi_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_NONE,
};
static struct gpiomux_setting gpio_spi_susp_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};
#endif
/* >> Arima_990211, 20130630, Merge M8610AAAAANLYD1011 */

static struct gpiomux_setting gpio_i2c_config = {
	.func = GPIOMUX_FUNC_3,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting gpio_cam_i2c_config = {
	.func = GPIOMUX_FUNC_1,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

//+ murphy 2013.11.05  QCT1032 merged
#if 0
static struct gpiomux_setting gpio_nfc_config = {
	.func = GPIOMUX_FUNC_2,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};
static struct gpiomux_setting gpio_nfc_sus_config = {
	.func = GPIOMUX_FUNC_2,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};
#endif
//- murphy 2013.11.05

/* -- Mel, 2013/06/25, Add gpio mux setting for SPI */
static struct gpiomux_setting gpio_spi_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting gpio_spi_cs_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
};
/* Mel, 2013/06/25, Add gpio mux setting for SPI -- */

/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */
#if 0
static struct gpiomux_setting atmel_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting atmel_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting atmel_reset_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting atmel_reset_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
};
#else
static struct gpiomux_setting touch_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting touch_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting touch_reset_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_OUT_HIGH, 
};

static struct gpiomux_setting touch_reset_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting touch_det_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting touch_det_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};
#endif
/* Mel, 2013/06/25, Modify gpio mux setting for Touch -- */

/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */
#if 0
static struct gpiomux_setting focaltech_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting focaltech_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting focaltech_reset_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting focaltech_reset_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};
#endif
/* Mel, 2013/06/25, Modify gpio mux setting for Touch -- */

static struct gpiomux_setting wcnss_5wire_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting wcnss_5wire_active_cfg = {
	.func = GPIOMUX_FUNC_1,
	.drv  = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting wcnss_5gpio_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv  = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting wcnss_5gpio_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv  = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting lcd_en_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_HIGH,
};

static struct gpiomux_setting lcd_en_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

/* -- Mel, 2013/06/25, Remove gpio mux setting for LCD */	
#if 0
static struct gpiomux_setting lcd_te_act_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting lcd_te_sus_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_IN,
};
#endif	
/* Mel, 2013/06/25, Remove gpio mux setting for LCD -- */	

static struct gpiomux_setting gpio_keys_active = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting gpio_keys_suspend = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

//+ murphy 2015.09.22  remove not used settings
#if 0
/* define gpio used as interrupt input */
static struct gpiomux_setting gpio_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting gpio_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct msm_gpiomux_config msm_gpio_int_configs[] __initdata = {
	{
		.gpio = 84,
		.settings = {
			[GPIOMUX_ACTIVE]	= &gpio_int_act_cfg,
			[GPIOMUX_SUSPENDED]	= &gpio_int_sus_cfg,
		},
	},
};
#endif
//- murphy 2015.09.22  remove not used settings


//tracy add for led ++
static struct gpiomux_setting led_en_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_HIGH,
};
//tracy add for led--
//20150930 tracy add for 5815 backlight control start
static struct gpiomux_setting led_en_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};
//20150930 tracy add for 5815 backlight control end

/*20130815 tracy for TCL/Truly DP/PDP LCM detection++*/
static struct gpiomux_setting lcd_det_act_cfg= {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	
};

static struct gpiomux_setting dp_det_act_cfg= {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_IN,
};
/*20130815 tracy for TCL/Truly DP/PDP LCM detection--*/

static struct msm_gpiomux_config msm_lcd_configs[] __initdata = {
	{
		.gpio = 41,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcd_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &lcd_en_sus_cfg,
		},
	},
/*20130815 tracy for TCL/Truly DP/PDP LCM detection++*/
	{
		.gpio = 78,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcd_det_act_cfg,
			//[GPIOMUX_SUSPENDED] = &lcd_det_act_cfg,
		},
	},
/*20130815 tracy for TCL/Truly DP/PDP LCM detection--*/
/* -- Mel, 2013/06/25, Remove gpio mux setting for LCD */				
#if 0	
	{
		.gpio = 7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcd_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &lcd_en_sus_cfg,
		},
	},
	{
		.gpio = 12,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcd_te_act_config,
			[GPIOMUX_SUSPENDED] = &lcd_te_sus_config,
		},
	},
#endif	
/* Mel, 2013/06/25, Remove gpio mux setting for LCD -- */	
};
//20150930 tracy modify for 5815 backlight control start
#if 0
//tracy add for led++
static struct msm_gpiomux_config msm_led_configs[] __initdata = {
	{
		.gpio = 18,
		.settings = {
			[GPIOMUX_ACTIVE]    = &led_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &led_en_act_cfg,
		},
	},
};
//tracy add for led	--
#else
static struct msm_gpiomux_config msm_led_configs[] __initdata = {
	{
		.gpio = 18,
		.settings = {
			[GPIOMUX_ACTIVE]    = &led_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &led_en_sus_cfg,
		},
	},
};
#endif
//20150930 tracy modify for 5815 backlight control end

/*20130815 tracy for TCL/Truly DP/PDP LCM detection++*/
static struct msm_gpiomux_config msm_dp_configs[] __initdata = {
	{
		.gpio = 35,
		.settings = {
			[GPIOMUX_ACTIVE]    = &dp_det_act_cfg,
			[GPIOMUX_SUSPENDED] = &dp_det_act_cfg,
		},
	},
};
/*20130815 tracy for TCL/Truly DP/PDP LCM detection--*/

/*<<Skies-2013/06/27, UART BLSP2 for serial console*/
static struct gpiomux_setting serial_console_active_cfg = {
	.func = GPIOMUX_FUNC_2,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_NONE,
};
/*
static struct gpiomux_setting serial_console_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};
*/
/*>>Skies-2013/06/27, UART BLSP2 for serial console*/

static struct msm_gpiomux_config msm_blsp_configs[] __initdata = {
	{
		.gpio      = 2,		/* BLSP1 QUP1 I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 3,		/* BLSP1 QUP1 I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
/*<<Skies-2013/06/27, UART BLSP2 for serial console*/	
	{
		.gpio = 4,	/* BLSP2_UART_TX */
		.settings = {
			[GPIOMUX_ACTIVE] = &serial_console_active_cfg,
			//[GPIOMUX_SUSPENDED] = &serial_console_suspend_cfg,
		},
	},
	{
		.gpio = 5, /* BLSP2_UART_RX */
		.settings = {
			[GPIOMUX_ACTIVE] = &serial_console_active_cfg,
			//[GPIOMUX_SUSPENDED] = &serial_console_suspend_cfg,
		},
	},
/*>>Skies-2013/06/27, UART BLSP2 for serial console*/				
	{
		.gpio      = 10,	/* BLSP1 QUP3 I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 11,	/* BLSP1 QUP3 I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 16,	/* BLSP1 QUP6 I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_cam_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_cam_i2c_config,
		},
	},
	{
		.gpio      = 17,	/* BLSP1 QUP6 I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_cam_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_cam_i2c_config,
		},
	},
//+ murphy 2013.11.05  QCT1032 merged
#if 0
	{
		.gpio      = 78,	/* NFC CLK */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_nfc_config,
			[GPIOMUX_SUSPENDED] = &gpio_nfc_sus_config,
		},
	},
#endif
//- murphy 2013.11.05  QCT1032 merged

/* -- Mel, 2013/06/25, Add DTV SPI gpio mux setting */
	{
		.gpio      = 86, 	/* DTV_SPI_RXD */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_spi_config,
		},
	},
	{
		.gpio      = 87,	      /* DTV_SPI_TXD */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_spi_config,
		},
	},
       {
		.gpio      = 88,	     /* DTV_SPI_DATA */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_spi_cs_config,
		},
	},
	{
		.gpio      = 89,	    /* DTV_SPI_SCK */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_spi_config,
		},
	},
/* Mel, 2013/06/25, Add DTV SPI gpio mux setting -- */
};

//+ murphy 2013.12.31  QCT_KK merged
#if 0
static struct gpiomux_setting gpio_i2c_nfc_pvt_config = {
		.func = GPIOMUX_FUNC_5, /*active 1*/ /* 0 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_NONE,
	};

static struct msm_gpiomux_config msm_nfc_configs[] __initdata = {
	{
		.gpio   = 8,            /* BLSP1 QUP2 I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_nfc_pvt_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_nfc_pvt_config,
		},
	},
	{
		.gpio   = 9,            /* BLSP1 QUP2 I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_i2c_nfc_pvt_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_nfc_pvt_config,
		},
	},
};
#endif
//- murphy 2013.12.31  QCT_KK merged

/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */
#if 0
static struct msm_gpiomux_config msm_atmel_configs[] __initdata = {
	{
		.gpio      = 0,		/* TOUCH RESET */
		.settings = {
			[GPIOMUX_ACTIVE] = &atmel_reset_act_cfg,
			[GPIOMUX_SUSPENDED] = &atmel_reset_sus_cfg,
		},
	},
	{
		.gpio      = 1,		/* TOUCH INT */
		.settings = {
			[GPIOMUX_ACTIVE] = &atmel_int_act_cfg,
			[GPIOMUX_SUSPENDED] = &atmel_int_sus_cfg,
		},
	},
	{
		.gpio      = 86,		/* BLSP1 QUP4 SPI_DATA_MOSI */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 87,		/* BLSP1 QUP4 SPI_DATA_MISO */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 89,		/* BLSP1 QUP4 SPI_CLK */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 88,		/* BLSP1 QUP4 SPI_CS */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
};
#else
static struct msm_gpiomux_config msm_touch_configs[] __initdata = {
	{
		.gpio      = 0,		/* TOUCH RESET */
		.settings = {
			[GPIOMUX_ACTIVE] = &touch_reset_act_cfg,
			[GPIOMUX_SUSPENDED] = &touch_reset_sus_cfg,
		},
	},
	{
		.gpio      = 1,		/* TOUCH INT */
		.settings = {
			[GPIOMUX_ACTIVE] = &touch_int_act_cfg,
			[GPIOMUX_SUSPENDED] = &touch_int_sus_cfg,
		},
	},
	{
		.gpio      = 2,		/* TS_I2C_SDA */
		.settings = {
		       [GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 3,		/* TS_I2C_SCL */
		.settings = {
		       [GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 7,		/* TP DET */
		.settings = {
			[GPIOMUX_ACTIVE] = &touch_det_act_cfg,
			[GPIOMUX_SUSPENDED] = &touch_det_sus_cfg,
		},
	},
};
#endif
/* Mel, 2013/06/25, Modify gpio mux setting for Touch -- */

/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */
#if 0
static struct msm_gpiomux_config msm_focaltech_configs[] __initdata = {
	{
		.gpio      = 0,		/* TOUCH RESET */
		.settings = {
			[GPIOMUX_ACTIVE] = &focaltech_reset_act_cfg,
			[GPIOMUX_SUSPENDED] = &focaltech_reset_sus_cfg,
		},
	},
	{
		.gpio      = 1,		/* TOUCH INT */
		.settings = {
			[GPIOMUX_ACTIVE] = &focaltech_int_act_cfg,
			[GPIOMUX_SUSPENDED] = &focaltech_int_sus_cfg,
		},
	},
	{
		.gpio      = 86,		/* BLSP1 QUP4 SPI_DATA_MOSI */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 87,		/* BLSP1 QUP4 SPI_DATA_MISO */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 89,		/* BLSP1 QUP4 SPI_CLK */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
	{
		.gpio      = 88,		/* BLSP1 QUP4 SPI_CS */
		.settings = {
			[GPIOMUX_ACTIVE] = &gpio_spi_config,
			[GPIOMUX_SUSPENDED] = &gpio_spi_susp_config,
		},
	},
};
#endif
/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */

static struct msm_gpiomux_config wcnss_5wire_interface[] = {
	{
		.gpio = 23,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5wire_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5wire_suspend_cfg,
		},
	},
	{
		.gpio = 24,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5wire_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5wire_suspend_cfg,
		},
	},
	{
		.gpio = 25,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5wire_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5wire_suspend_cfg,
		},
	},
	{
		.gpio = 26,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5wire_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5wire_suspend_cfg,
		},
	},
	{
		.gpio = 27,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5wire_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5wire_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config wcnss_5gpio_interface[] = {
	{
		.gpio = 23,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5gpio_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5gpio_suspend_cfg,
		},
	},
	{
		.gpio = 24,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5gpio_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5gpio_suspend_cfg,
		},
	},
	{
		.gpio = 25,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5gpio_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5gpio_suspend_cfg,
		},
	},
	{
		.gpio = 26,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5gpio_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5gpio_suspend_cfg,
		},
	},
	{
		.gpio = 27,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wcnss_5gpio_active_cfg,
			[GPIOMUX_SUSPENDED] = &wcnss_5gpio_suspend_cfg,
		},
	},
};

static struct gpiomux_setting gpio_suspend_config[] = {
	{
		.func = GPIOMUX_FUNC_GPIO,  /* IN-NP */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_NONE,
	},
	{
		.func = GPIOMUX_FUNC_GPIO,  /* O-LOW */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_NONE,
		.dir = GPIOMUX_OUT_LOW,
	},
};

static struct gpiomux_setting cam_settings[] = {
	{
		.func = GPIOMUX_FUNC_1, /*active 1*/ /* 0 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_NONE,
	},

	{
		.func = GPIOMUX_FUNC_1, /*suspend*/ /* 1 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_DOWN,
	},

	{
		.func = GPIOMUX_FUNC_1, /*i2c suspend*/ /* 2 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_KEEPER,
	},

	{
		.func = GPIOMUX_FUNC_GPIO, /*active 0*/ /* 3 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_NONE,
	},

	{
		.func = GPIOMUX_FUNC_GPIO, /*suspend 0*/ /* 4 */
		.drv = GPIOMUX_DRV_2MA,
		.pull = GPIOMUX_PULL_DOWN,
	},
};

//+ murphy 2013.12.31  QCT_KK merged
#if 0
static struct gpiomux_setting accel_interrupt_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct msm_gpiomux_config msm_non_qrd_configs[] __initdata = {
	{
		.gpio = 8, /* CAM1_STANDBY_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 81,	/*ACCEL_INT1 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &accel_interrupt_config,
			[GPIOMUX_SUSPENDED] = &accel_interrupt_config,
		},
	},
};
#endif
//- murphy 2013.12.31  QCT_KK merged

/* -- Mel, 2013/06/25, Modify gpio mux setting for P, G, E sensors */	
static struct gpiomux_setting gpio_sensors_int_active = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting gpio_sensors_int_suspend = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting gpio_sensors_rst_active = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting gpio_sensors_rst_suspend = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};
/* Mel, 2013/06/25, Modify gpio mux setting for P, G, E sensors --*/	

static struct msm_gpiomux_config msm_sensor_configs[] __initdata = {
/* -- Mel, 2013/06/25, Modify gpio mux setting for Camera */	
#if 0	
	{
		.gpio = 13, /* CAM_MCLK0 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 14, /* CAM_MCLK1 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 16, /* CCI_I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[0],
		},
	},
	{
		.gpio = 17, /* CCI_I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[0],
		},
	},
	{
		.gpio = 18, /* FLASH_LED_EN */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 19, /* FLASH_LED_NOW */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 8, /* CAM1_STANDBY_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 15, /* CAM1_RST_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 20, /* WEBCAM1_STANDBY */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 21, /* WEBCAM2_RESET_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
#else
// + murphy 2015.09.16  Camera S5K5E2, GC0310 driver settings
#if 1
  //S5K5E2 sensor
	{
		.gpio = 13,        /* CAM_MCLK0 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 21,       /* CAM1_RST_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
  {
    .gpio = 8,         /* CAM_1V2_EN */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[3],
      [GPIOMUX_SUSPENDED] = &cam_settings[1],
    },
  },
  {
    .gpio = 99,         /* CAM_1V8_EN */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[3],
      [GPIOMUX_SUSPENDED] = &cam_settings[1],
    },
  },
  {
    .gpio = 9,          /* CCI_2V8_EN */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[3],
      [GPIOMUX_SUSPENDED] = &cam_settings[1],
    },
  },
  //GC0310 sensor
  {
    .gpio = 14,        /* CAM_MCLK1 */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[0],
      [GPIOMUX_SUSPENDED] = &cam_settings[1],
    },
  },
  {
    .gpio = 20,       /* CAM2_RST_N */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[3],
      [GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
    },
  },
  {
    .gpio = 84,       /* SUBCAM_PW_ON */
    .settings = {
      [GPIOMUX_ACTIVE]    = &cam_settings[3],
      [GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
    },
  },
  // LM3648 LED flash driver. By Ted Li. 2015-10-06 ++
  {
		.gpio = 19, /* FLASH_LED_EN */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
  },
  // LM3648 LED flash driver. By Ted Li. 2015-10-06 --
#else
	{
		.gpio = 8,         /* CAM_1V8_EN */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 9,          /* CCI_2V8_EN */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 13,        /* CAM_MCLK0 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &cam_settings[1],
		},
	},
	{
		.gpio = 16,        /* CCI_I2C_SDA */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[0],
		},
	},
	{
		.gpio = 17,        /* CCI_I2C_SCL */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[0],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[0],
		},
	},
	{
		.gpio = 21,       /* CAM1_RST_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 84,       /* CAM1_PW_ON */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[1],
		},
	},
	{
		.gpio = 85,       /* CAM1_ID */
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_settings[3],
			[GPIOMUX_SUSPENDED] = &gpio_suspend_config[0],
		},
	},
#endif
// - murphy 2015.09.16  Camera S5K5E2, GC0310 driver settings
#endif
/* Mel, 2013/06/25, Modify gpio mux setting for Camera --*/
/* -- Mel, 2013/06/25, Modify gpio mux setting for P, G, E sensors */	
	{
		.gpio      = 10,		/* SENSORS_I2C_SDA */
		.settings = {
		       [GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio      = 11,		/* SENSORS_I2C_SCL */
		.settings = {
		       [GPIOMUX_ACTIVE] = &gpio_i2c_config,
			[GPIOMUX_SUSPENDED] = &gpio_i2c_config,
		},
	},
	{
		.gpio = 80,      /* PROXIMITY_INT_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_sensors_int_active,
			[GPIOMUX_SUSPENDED] = &gpio_sensors_int_suspend,
		},
	},
	{
		.gpio = 81,      /* ACCL_INT_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_sensors_int_active,
			[GPIOMUX_SUSPENDED] = &gpio_sensors_int_suspend,
		},
	},
	{
		.gpio = 82,      /* ACCL_INT2_N */
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_sensors_int_active,
			[GPIOMUX_SUSPENDED] = &gpio_sensors_int_suspend,
		},
	},
	{
		.gpio = 83,      /* MAG_INT */
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_sensors_int_active,
			[GPIOMUX_SUSPENDED] = &gpio_sensors_int_suspend,
		},
	},
	{
		.gpio = 6,      /* ECOMPASS_RST */
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_sensors_rst_active,
			[GPIOMUX_SUSPENDED] = &gpio_sensors_rst_suspend,
		},
	},
/* Mel, 2013/06/25, Modify gpio mux setting for P, G, E sensors --*/	
};

static struct msm_gpiomux_config msm_keypad_configs[] __initdata = {
	{
		.gpio = 72,
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_keys_active,
			[GPIOMUX_SUSPENDED] = &gpio_keys_suspend,
		},
	},
	{
		.gpio = 73,
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_keys_active,
			[GPIOMUX_SUSPENDED] = &gpio_keys_suspend,
		},
	},
	{
		.gpio = 74,
		.settings = {
			[GPIOMUX_ACTIVE]    = &gpio_keys_active,
			[GPIOMUX_SUSPENDED] = &gpio_keys_suspend,
		},
	},
};

//[Arima Edison] add for enable isdbt ++
#if 0
static struct gpiomux_setting dtv_reset_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW, 
};

static struct gpiomux_setting dtv_en_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting dtv_int_act_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting dtv_int_sus_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct msm_gpiomux_config msm_dtv_configs[] __initdata = {
	{
		.gpio = 79, /*DTV EN DP*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &dtv_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &dtv_en_act_cfg,
		},
	},
	{
		.gpio = 91, /*DTV RESET DP*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &dtv_reset_act_cfg,
			[GPIOMUX_SUSPENDED] = &dtv_reset_act_cfg,
		},
	},
	{
		.gpio = 101, /*DTV IRQ DP*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &dtv_int_act_cfg,
			[GPIOMUX_SUSPENDED] = &dtv_int_sus_cfg,
		},
	},
	{
		.gpio = 90, /*DTV IRQ PDP2*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &dtv_int_act_cfg,
			[GPIOMUX_SUSPENDED] = &dtv_int_sus_cfg,
		},
	},
	{
		.gpio = 92, /*DTV EN PDP2*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &dtv_en_act_cfg,
			[GPIOMUX_SUSPENDED] = &dtv_en_act_cfg,
		},
	},
};
#endif
//[Arima Edison] add for enable isdbt --

static struct gpiomux_setting sd_card_det_active_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting sd_card_det_suspend_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct msm_gpiomux_config sd_card_det[] __initdata = {
	{
		.gpio = 42,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sd_card_det_active_config,
			[GPIOMUX_SUSPENDED] = &sd_card_det_suspend_config,
		},
	},
};

//+ murphy 2013.12.31  QCT_KK merged
#if 0
static struct gpiomux_setting interrupt_gpio_active = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting interrupt_gpio_suspend_pullup = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting interrupt_gpio_suspend_pulldown = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct msm_gpiomux_config msm_interrupt_configs[] __initdata = {
	{
		.gpio = 75,	/* NFC_CLK_REQ_IRQ*/
		.settings = {
			[GPIOMUX_ACTIVE]    = &interrupt_gpio_active,
			[GPIOMUX_SUSPENDED] = &interrupt_gpio_suspend_pullup,
		},
	},
	{
		.gpio = 77,	/* NFC_IRQ */
		.settings = {
			[GPIOMUX_ACTIVE]    = &interrupt_gpio_active,
			[GPIOMUX_SUSPENDED] = &interrupt_gpio_suspend_pullup,
		},
	},
	{
		.gpio = 80,	/*ALSP_INT */
		.settings = {
			[GPIOMUX_ACTIVE]    = &interrupt_gpio_active,
			[GPIOMUX_SUSPENDED] = &interrupt_gpio_suspend_pullup,
		},
	},
	{
		.gpio = 81,	/*ACCEL_INT1 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &interrupt_gpio_active,
			[GPIOMUX_SUSPENDED] = &interrupt_gpio_suspend_pulldown,
		},
	},
	{
		.gpio = 82,	/*ACCEL_INT2 */
		.settings = {
			[GPIOMUX_ACTIVE]    = &interrupt_gpio_active,
			[GPIOMUX_SUSPENDED] = &interrupt_gpio_suspend_pulldown,
		},
	},
};

static struct gpiomux_setting gpio_cdc_dmic_cfg = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_4MA,
	.pull = GPIOMUX_PULL_NONE,
};


static struct msm_gpiomux_config msm_cdc_dmic_configs[] __initdata = {
	{
		.gpio = 100,	/* DMIC CLK */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_cdc_dmic_cfg,
		},
	},
	{
		.gpio = 101,	/* DMIC DATA */
		.settings = {
			[GPIOMUX_SUSPENDED] = &gpio_cdc_dmic_cfg,
		},
	},
};

static struct gpiomux_setting ice40_spi_cs_act_config = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting ice40_spi_cs_susp_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_6MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting ice40_act_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting ice40_susp_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct msm_gpiomux_config ice40_spi_usb_configs[] __initdata = {
	{
		.gpio = 85,
		.settings = {
			[GPIOMUX_ACTIVE] = &ice40_spi_cs_act_config,
			[GPIOMUX_SUSPENDED] = &ice40_spi_cs_susp_config,
		},
	},
	{
		.gpio = 94,
		.settings = {
			[GPIOMUX_ACTIVE] = &ice40_act_config,
			[GPIOMUX_SUSPENDED] = &ice40_susp_config,
		},
	},
	{
		.gpio = 95,
		.settings = {
			[GPIOMUX_ACTIVE] = &ice40_act_config,
			[GPIOMUX_SUSPENDED] = &ice40_susp_config,
		},
	},
	{
		.gpio = 96,
		.settings = {
			[GPIOMUX_ACTIVE] = &ice40_act_config,
			[GPIOMUX_SUSPENDED] = &ice40_susp_config,
		},
	},
};
#endif
//- murphy 2013.12.31  QCT_KK merged

void __init msm8610_init_gpiomux(void)
{
	int rc;

	rc = msm_gpiomux_init_dt();
	if (rc) {
		pr_err("%s failed %d\n", __func__, rc);
		return;
	}

	msm_gpiomux_install(msm_blsp_configs, ARRAY_SIZE(msm_blsp_configs));
/* -- Mel, 2013/06/25, Modify gpio mux setting for Touch */	
#if 0
	if (of_board_is_qrd()) {
		msm_gpiomux_install(msm_focaltech_configs,
			ARRAY_SIZE(msm_focaltech_configs));
	} else {
		msm_gpiomux_install(msm_atmel_configs,
			ARRAY_SIZE(msm_atmel_configs));
	}
#else
	msm_gpiomux_install(msm_touch_configs,
			ARRAY_SIZE(msm_touch_configs));
#endif
/* Mel, 2013/06/25, Modify gpio mux setting for Touch -- */
	msm_gpiomux_install(wcnss_5wire_interface,
			ARRAY_SIZE(wcnss_5wire_interface));
	msm_gpiomux_install_nowrite(msm_lcd_configs,
				ARRAY_SIZE(msm_lcd_configs));
	msm_gpiomux_install(msm_keypad_configs,
				ARRAY_SIZE(msm_keypad_configs));
	msm_gpiomux_install(sd_card_det, ARRAY_SIZE(sd_card_det));
	msm_gpiomux_install(msm_sensor_configs, ARRAY_SIZE(msm_sensor_configs));

  //+ murphy 2015.09.22  remove not used settings
  #if 0
	msm_gpiomux_install(msm_gpio_int_configs,
			ARRAY_SIZE(msm_gpio_int_configs));
  #endif
	//- murphy 2015.09.22  remove not used settings

//+ murphy 2013.12.31  QCT_KK merged
#if 0
	if (of_board_is_qrd()) {
		msm_gpiomux_install(msm_interrupt_configs,
			ARRAY_SIZE(msm_interrupt_configs));
		msm_gpiomux_install(msm_nfc_configs,
			ARRAY_SIZE(msm_nfc_configs));
	} else {
		msm_gpiomux_install(msm_non_qrd_configs,
			ARRAY_SIZE(msm_non_qrd_configs));
	}
	if (of_board_is_cdp())
		msm_gpiomux_install(msm_cdc_dmic_configs,
			ARRAY_SIZE(msm_cdc_dmic_configs));

	if (of_board_is_cdp())
		msm_gpiomux_install(ice40_spi_usb_configs,
			ARRAY_SIZE(ice40_spi_usb_configs));
#endif
	msm_gpiomux_install(msm_led_configs, ARRAY_SIZE(msm_led_configs));  //tracy add for led
	msm_gpiomux_install(msm_dp_configs, ARRAY_SIZE(msm_dp_configs));  /*20130815 tracy for TCL/Truly DP/PDP LCM detection*/
	//[Arima Edison] add for enable isdbt ++
	//msm_gpiomux_install(msm_dtv_configs, ARRAY_SIZE(msm_dtv_configs));
	//[Arima Edison] add for enable isdbt --

//- murphy 2013.12.31  QCT_KK merged
}

static void wcnss_switch_to_gpio(void)
{
	/* Switch MUX to GPIO */
	msm_gpiomux_install(wcnss_5gpio_interface,
			ARRAY_SIZE(wcnss_5gpio_interface));

	/* Ensure GPIO config */
	gpio_direction_input(WLAN_DATA2);
	gpio_direction_input(WLAN_DATA1);
	gpio_direction_input(WLAN_DATA0);
	gpio_direction_output(WLAN_SET, 0);
	gpio_direction_output(WLAN_CLK, 0);
}

static void wcnss_switch_to_5wire(void)
{
	msm_gpiomux_install(wcnss_5wire_interface,
			ARRAY_SIZE(wcnss_5wire_interface));
}

u32 wcnss_rf_read_reg(u32 rf_reg_addr)
{
	int count = 0;
	u32 rf_cmd_and_addr = 0;
	u32 rf_data_received = 0;
	u32 rf_bit = 0;

	wcnss_switch_to_gpio();

	/* Reset the signal if it is already being used. */
	gpio_set_value(WLAN_SET, 0);
	gpio_set_value(WLAN_CLK, 0);

	/* We start with cmd_set high WLAN_SET = 1. */
	gpio_set_value(WLAN_SET, 1);

	gpio_direction_output(WLAN_DATA0, 1);
	gpio_direction_output(WLAN_DATA1, 1);
	gpio_direction_output(WLAN_DATA2, 1);

	gpio_set_value(WLAN_DATA0, 0);
	gpio_set_value(WLAN_DATA1, 0);
	gpio_set_value(WLAN_DATA2, 0);

	/* Prepare command and RF register address that need to sent out.
	 * Make sure that we send only 14 bits from LSB.
	 */
	rf_cmd_and_addr  = (((WLAN_RF_READ_REG_CMD) |
		(rf_reg_addr << WLAN_RF_REG_ADDR_START_OFFSET)) &
		WLAN_RF_READ_CMD_MASK);

	for (count = 0; count < 5; count++) {
		gpio_set_value(WLAN_CLK, 0);

		rf_bit = (rf_cmd_and_addr & 0x1);
		gpio_set_value(WLAN_DATA0, rf_bit ? 1 : 0);
		rf_cmd_and_addr = (rf_cmd_and_addr >> 1);

		rf_bit = (rf_cmd_and_addr & 0x1);
		gpio_set_value(WLAN_DATA1, rf_bit ? 1 : 0);
		rf_cmd_and_addr = (rf_cmd_and_addr >> 1);

		rf_bit = (rf_cmd_and_addr & 0x1);
		gpio_set_value(WLAN_DATA2, rf_bit ? 1 : 0);
		rf_cmd_and_addr = (rf_cmd_and_addr >> 1);

		/* Send the data out WLAN_CLK = 1 */
		gpio_set_value(WLAN_CLK, 1);
	}

	/* Pull down the clock signal */
	gpio_set_value(WLAN_CLK, 0);

	/* Configure data pins to input IO pins */
	gpio_direction_input(WLAN_DATA0);
	gpio_direction_input(WLAN_DATA1);
	gpio_direction_input(WLAN_DATA2);

	for (count = 0; count < 2; count++) {
		gpio_set_value(WLAN_CLK, 1);
		gpio_set_value(WLAN_CLK, 0);
	}

	rf_bit = 0;
	for (count = 0; count < 6; count++) {
		gpio_set_value(WLAN_CLK, 1);
		gpio_set_value(WLAN_CLK, 0);

		rf_bit = gpio_get_value(WLAN_DATA0);
		rf_data_received |= (rf_bit << (count * 3 + 0));

		if (count != 5) {
			rf_bit = gpio_get_value(WLAN_DATA1);
			rf_data_received |= (rf_bit << (count * 3 + 1));

			rf_bit = gpio_get_value(WLAN_DATA2);
			rf_data_received |= (rf_bit << (count * 3 + 2));
		}
	}

	gpio_set_value(WLAN_SET, 0);
	wcnss_switch_to_5wire();

	return rf_data_received;
}
