# Developing IDAPython: best practices

### Rule of thumb

If you are doing something non-trivial in IDAPython, or if you added something
to the C++ SDK which will then be reflected in IDAPython, an *immensely*
useful rule-of-thumb is to perform a diff of the autogenerated SWiG wrappers.

Typically:
`cp -R obj/x64_linux_gcc_32/3/wrappers/ /tmp/wrappers-before`
<recompile...>
`git diff /tmp/wrappers-before/ obj/x64_linux_gcc_32/3/wrappers/`

It is always useful to make sure that SWiG did the right thing -- *especially*
when modifying typemaps, but not only.

### How to add new module?

We use the "zzz" placeholder for a module name in this "how-to".

1. create file swig/zzz.i
```
%{
#include <zzz.hpp>
%}
%include "zzz.hpp"
```

2. add zzz to the `MODULES_NAMES` var in makefile

3. add zzz to `SDK_FILES` var in etc/sdk/sdk_files.mak

4. add a line to python/idc.py if you want to autoload this module
```
import ida_zzz
```

5. build

6. update the content of api_contents.txt
   (from obj/.../api_contents.txt.new)

7. rebuild

8. update the content of pydoc_injections.txt
   (from obj/.../pydoc_injections.txt)
