
# IDAPython runtime documentation

We define the "IDAPython runtime documentation" as the documentation
that's available through Python's `help()` system, while the user is
interacting with `IDAPython` during an IDA session.

That documentation is SWiG-generated + patched, or custom written.

## Custom-written documentation

Some functions have custom-written documentation (check for <pydoc>
tags in the `pywraps/` directory), but the general case is that the
documentation is automatically generated by SWiG, and then patched.

## SWiG-generated + patched documentation

Because SWiG doesn't know about the C++ SDK header's documentation, we
need a way to "import" that documentation into IDAPython.

That's done by `tools/inject_pydoc.py` which deserves
[its own documentation](inject_pydoc.md)
