//--------------------------------------------------------------------------
static char *token2str(char *buf, size_t bufsize, GEOStoken &t)
{
  if ( t.str[0] )
    qsnprintf(buf, bufsize, "%4.4s/%u", t.str, t.num);
  else
    qstrncpy(buf, "-", bufsize);
  return buf;
}

//--------------------------------------------------------------------------
static const unsigned char _GeosXlate[] =
{
  0x8E, 0x8F, 0x80, 0x90, 0xA5, 0x99, 0x9A, 0xA0,
  0x85, 0x83, 0x84, 0x20, 0x86, 0x87, 0x82, 0x8A,
  0x88, 0x89, 0xA1, 0x8D, 0x8C, 0x8B, 0xA4, 0xA2,
  0x95, 0x93, 0x94, 0x20, 0xA3, 0x97, 0x96, 0x81,
  0x20, 0xF8, 0x9B, 0x9C, 0x15, 0xF9, 0x14, 0xE1,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x92, 0x20,
  0xEC, 0xF1, 0xF3, 0xF2, 0x9D, 0xE6, 0xEB, 0xE4,
  0x20, 0x20, 0xF4, 0xA6, 0xA7, 0xEA, 0x91, 0xED,
  0xA8, 0xAD, 0xAA, 0xFB, 0x9F, 0xF7, 0x20, 0xAE,
  0xAF, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xF6, 0x04,
  0x98, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
};

static const unsigned char _GeosXlapp[] =
{
  0x8E, 0x8F, 0x80, 0x90, 0xA5, 0x99, 0x9A, 0xA0,
  0x85, 0x83, 0x84, 0x61, 0x86, 0x87, 0x82, 0x8A,
  0x88, 0x89, 0xA1, 0x8D, 0x8C, 0x8B, 0xA4, 0xA2,
  0x95, 0x93, 0x94, 0x6F, 0xA3, 0x97, 0x96, 0x81,
  0x2B, 0xF8, 0x9B, 0x9C, 0x15, 0xF9, 0x14, 0xE1,
  0x52, 0x43, 0x7E, 0x27, 0x22, 0xD8, 0x92, 0x30,
  0xEC, 0xF1, 0xF3, 0xF2, 0x9D, 0xE6, 0xEB, 0xE4,
  0xE3, 0xE3, 0xF4, 0xA6, 0xA7, 0xEA, 0x91, 0xED,
  0xA8, 0xAD, 0xAA, 0xFB, 0x9F, 0xF7, 0x1E, 0xAE,
  0xAF, 0x5F, 0x20, 0x41, 0x41, 0x4F, 0x99, 0x94,
  0x2D, 0xC4, 0x22, 0x22, 0x60, 0x27, 0xF6, 0x04,
  0x98, 0x59, 0x2F, 0xE8, 0x3C, 0x3E, 0x79, 0x59,
  0x2B, 0xFA, 0x2C, 0x22, 0x70, 0x41, 0x45, 0x41,
  0x45, 0x45, 0x49, 0x49, 0x49, 0x49, 0x4F, 0x4F,
  0x20, 0x4F, 0x55, 0x55, 0x55, 0x2C, 0x5E, 0x7E,
  0x2D, 0x60, 0xF8, 0xF8, 0x2C, 0x22, 0x2C, 0x27
};


static char *geos2ibm(char *out, char *in, size_t insize)
{
  char *saved = out;
  for ( int i=0; i < insize; i++ )
  {
    uchar c = *in++;
    if ( !c )
      break;
    if ( c & 0x80 )
      c = _GeosXlapp[c & 0x7F];
    *out++ = c;
  }
  *out = '\0';
  return saved;
}


